# Agentic Press WordPress Plugin

**Version 1.0.0** - Production Ready

A comprehensive WordPress plugin that provides author-category management, AI content generation integration, and automatic API deployment. **Self-contained and theme-agnostic** - works with any WordPress theme.

## Features

- **🔧 One-Click Installation**: Plugin automatically creates database tables and deploys API endpoints on activation
- **🚀 Automatic API Deployment**: Copies API files to `/api/` directory with proper permissions (0644 files, 0755 directories)
- **💰 Affiliate Management**: Database-driven affiliate product links with `[affiliate_box]` shortcodes and automatic disclosures
- **📂 Category Management**: Create, edit, and delete categories with full metadata (prompts, LLM settings, etc.)
- **👥 Author Assignment**: Assign authors to categories through the admin interface
- **🔗 REST API**: Query authors by category and manage content with Bearer token authentication
- **🗄️ Database Auto-Migration**: One-time migration from `categories.json` to WordPress database tables
- **📊 Hierarchical Categories**: Support for subcategories with inheritance
- **🎛️ Admin Interface**: User-friendly management interface for all operations
- **🎨 Theme Agnostic**: All frontend functionality included - no child theme required
- **🏗️ SaaS-Ready**: Architecture prepared for future hosted service integration

## Installation

1. Upload the `autopress` folder to `/wp-content/plugins/`
2. Activate the plugin through the WordPress admin
3. The plugin will automatically create database tables and migrate data from `categories.json`

## Usage

### Admin Interface
- Navigate to **Users > Category Management** to manage categories
- Add/edit categories with all metadata fields
- View and manage author assignments

### User Creation
- When creating new users, select a category from the dropdown
- Category assignment is required for authors

### API Usage
Query authors by category:

```
GET /wp-json/ap/v1/authors?category=art-design&include_subcategories=true
```

Get all categories:

```
GET /wp-json/ap/v1/categories?active_only=true
```

## Database Schema

### ap_categories
- `id`: Primary key
- `category_slug`: Unique identifier
- `name`: Display name
- `description`: Category description
- `system_prompt`, `user_prompt`: LLM prompts
- `llm_provider`, `model`: AI model settings
- `temperature`, `top_p`, `max_tokens`: Generation parameters
- `parent_id`: For subcategories
- `is_active`: Enable/disable status

### ap_authors_categories
- `author_id`: Foreign key to wp_users.ID
- `category_id`: Foreign key to ap_categories.id
- Unique constraint ensures one category per author

## Hooks and Filters

### Actions
- `ap_after_category_migration`: Fires after JSON migration
- `ap_author_category_assigned`: Fires when category is assigned

### Filters
- `ap_allowed_categories`: Modify available categories
- `ap_category_query_args`: Customize author queries

## Requirements
- WordPress 5.0+
- PHP 7.4+
- MySQL 5.6+

## Changelog

### 1.0.0
- Initial release
- Database migration from JSON
- Category management interface
- Author assignment functionality
- REST API endpoints

## Development History

This plugin was developed through an extensive collaborative session to create a comprehensive WordPress solution for managing author-category relationships with AI content generation integration.

### Original Requirements
- Migrate static `categories.json` data to dynamic WordPress database tables
- Enable admin-controlled author-category assignments
- Support full AI metadata editing (prompts, LLM settings, parameters)
- Provide REST API endpoints for Agentic Press content generation
- Integrate seamlessly with WordPress core category management

### Development Process

#### Phase 1: Plugin Architecture
- Created complete WordPress plugin structure with proper headers
- Implemented activation/deactivation hooks
- Set up class-based architecture with separation of concerns:
  - `AP_DB`: Database operations and migration
  - `AP_Admin`: Admin interface integration
  - `AP_User_Fields`: User profile management
  - `AP_API`: REST API endpoints

#### Phase 2: Database Design & Migration
- Designed hierarchical category table with full metadata support
- Created many-to-many relationship table for author-category assignments
- Implemented robust JSON migration with error handling and logging
- Added support for nested subcategory structures
- Handled multiple environments (prod/lab) from JSON structure

#### Phase 3: Admin Interface Integration
- **Major Decision**: Moved from separate admin pages to WordPress core category management
- Integrated all Agentic Press fields directly into Posts → Categories pages
- Added category add/edit form fields for AI metadata
- Implemented author assignment checkboxes with user filtering
- Created hierarchical category support in admin

#### Phase 4: User Profile Management
- Added category assignment display to user profiles
- Initially designed for single category per author
- Later enhanced to support multiple categories per author

#### Phase 5: Critical Bug Fixes & Enhancements

##### Issue 1: Role-Based Access Control
- **Problem**: Authors not appearing in assignment lists
- **Root Cause**: Users needed 'author', 'editor', or 'administrator' roles
- **Solution**: Updated role checking and user guidance

##### Issue 2: Single Category Limitation
- **Problem**: Database constraint limited authors to one category
- **Root Cause**: Unique index on `author_id` only
- **Solution**: 
  - Removed restrictive unique constraint
  - Added proper unique constraint on `(author_id, category_id)`
  - Updated admin interface to support multiple selections
  - Enhanced user profiles to display all assigned categories

##### Issue 3: Duplicate Database Entries
- **Problem**: Migration created duplicate assignments
- **Root Cause**: Migration inserted for each environment without duplicate checking
- **Solution**:
  - Added `DISTINCT` to queries
  - Implemented duplicate cleanup on plugin reactivation
  - Added proper database constraints

##### Issue 4: User Profile Display Issues
- **Problem**: User profiles showed only first category or duplicates
- **Root Cause**: Query returned single result or duplicates
- **Solution**: Created `get_categories_by_author()` method with proper deduplication

### Technical Implementation Details

#### Database Schema Evolution
```sql
-- Initial schema (restrictive)
UNIQUE KEY unique_author_category (author_id)

-- Final schema (flexible)
UNIQUE KEY unique_author_category (author_id, category_id)
```

#### Key Code Changes
- **Migration Logic**: Enhanced to handle nested JSON with environments
- **Admin Integration**: Complete WordPress category hook integration
- **User Interface**: Multi-select checkboxes with proper validation
- **API Endpoints**: RESTful design with proper authentication
- **Error Handling**: Comprehensive logging and graceful failures

#### WordPress Integration
- **Hooks Used**:
  - `category_add_form_fields`
  - `category_edit_form_fields`
  - `created_category`
  - `edited_category`
  - `manage_edit-category_columns`
- **User Management**: Profile field integration
- **Role System**: Proper capability checking

### Final Architecture

#### File Structure
```
autopress/
├── autopress.php              # Main plugin file
├── includes/
│   ├── class-ap-db.php        # Database operations
│   ├── class-ap-admin.php     # Admin interface
│   ├── class-ap-user-fields.php # User profiles
│   └── class-ap-api.php       # REST API
├── assets/
│   ├── css/admin.css          # Admin styling
│   └── js/admin.js            # Admin scripts
├── categories.json            # Source data
└── README.md                  # This documentation
```

#### Database Tables
- `wp_ap_categories`: Hierarchical category storage with AI metadata
- `wp_ap_authors_categories`: Many-to-many author-category relationships

#### API Endpoints
- `GET /wp-json/ap/v1/authors`: Query authors by category
- `GET /wp-json/ap/v1/categories`: Get category list

### Lessons Learned
1. **Database Constraints**: Proper unique keys prevent data integrity issues
2. **WordPress Integration**: Core integration provides better UX than separate admin pages
3. **Migration Robustness**: Handle complex JSON structures with multiple environments
4. **User Experience**: Support multiple assignments when business logic requires it
5. **Error Prevention**: Duplicate prevention at database level, not just application level

### Success Metrics
- ✅ Complete JSON migration with all data preserved
- ✅ Full WordPress core integration
- ✅ Multiple category assignments per author
- ✅ Clean, duplicate-free database
- ✅ Intuitive admin interface
- ✅ Comprehensive API for external integration
- ✅ Production-ready code with proper error handling

This development represents a complete WordPress plugin solution that successfully bridges static configuration data with dynamic content management, enabling sophisticated AI-powered content generation workflows.