<?php
// config.php - Sensitive credentials and configuration

function get_table_prefix() {
    $config_path = $_SERVER['DOCUMENT_ROOT'] . '/wp-config.php';
    $config = file_get_contents($config_path);

    if (preg_match("/\\\$table_prefix\\s*=\\s*['\"](.*?)['\"];/", $config, $matches)) {
        return $matches[1];
    }

    return null;
}

function get_wp_db_name() {
    $config_path = $_SERVER['DOCUMENT_ROOT'] . '/wp-config.php';
    $config = file_get_contents($config_path);

    // Try different quote patterns
    $patterns = [
        "/define\\s*\\(\\s*['\"]DB_NAME['\"]\\s*,\\s*['\"]([^'\"]+)['\"]\\s*\\)/",
        "/\\\$DB_NAME\\s*=\\s*['\"]([^'\"]+)['\"]/"
    ];

    foreach ($patterns as $pattern) {
        if (preg_match($pattern, $config, $matches)) {
            return $matches[1];
        }
    }

    return null; // Fallback if not found
}

function get_wp_db_username() {
    $config_path = $_SERVER['DOCUMENT_ROOT'] . '/wp-config.php';
    $config = file_get_contents($config_path);

    // Try different quote patterns
    $patterns = [
        "/define\\s*\\(\\s*['\"]DB_USER['\"]\\s*,\\s*['\"]([^'\"]+)['\"]\\s*\\)/",
        "/\\\$DB_USER\\s*=\\s*['\"]([^'\"]+)['\"]/"
    ];

    foreach ($patterns as $pattern) {
        if (preg_match($pattern, $config, $matches)) {
            return $matches[1];
        }
    }

    return null; // Fallback if not found
}

function get_wp_db_password() {
    $config_path = $_SERVER['DOCUMENT_ROOT'] . '/wp-config.php';
    $config = file_get_contents($config_path);

    // Try different quote patterns
    $patterns = [
        "/define\\s*\\(\\s*['\"]DB_PASSWORD['\"]\\s*,\\s*['\"]([^'\"]+)['\"]\\s*\\)/",
        "/\\\$DB_PASSWORD\\s*=\\s*['\"]([^'\"]+)['\"]/"
    ];

    foreach ($patterns as $pattern) {
        if (preg_match($pattern, $config, $matches)) {
            return $matches[1];
        }
    }

    return null; // Fallback if not found
}

function get_wp_db_host() {
    $config_path = $_SERVER['DOCUMENT_ROOT'] . '/wp-config.php';
    // SECURITY: Removed unsafe logging of file paths and contents
    if (!file_exists($config_path)) {
        // SECURITY: Removed logging of file path
        return 'localhost';
    }
    $config = file_get_contents($config_path);
    // SECURITY: Removed logging of file contents length and first 500 chars

    // Try different regex patterns
    $patterns = [
        "/define\\s*\\(\\s*['\"]DB_HOST['\"]\\s*,\\s*['\"]([^'\"]+)['\"]\\s*\\)/",
        "/define\\s*\\(\\s*'DB_HOST'\\s*,\\s*'([^']+)'\\s*\\)/",
        "/define\\s*\\(\\s*\"DB_HOST\"\\s*,\\s*\"([^\"]+)\"\\s*\\)/",
        "/\\\$DB_HOST\\s*=\\s*['\"]([^'\"]+)['\"]/"
    ];

    foreach ($patterns as $pattern) {
        if (preg_match($pattern, $config, $matches)) {
            // SECURITY: Removed logging of found values
            return $matches[1];
        }
    }

    // SECURITY: Removed logging of "not found" messages
    return 'localhost'; // Fallback if not found
}

// Agentic Press DB - API runs on same server as DB
$MYSQL_HOST = 'localhost';  // localhost from server perspective
$MYSQL_DB   = get_wp_db_name();  // Use WP DB instead of separate auto_press DB
$MYSQL_USER = get_wp_db_username();
$MYSQL_PASS = get_wp_db_password();

// WordPress DB - for WordPress data access
$WP_HOST = get_wp_db_host();
$WP_DB   = get_wp_db_name();
$WP_USER = get_wp_db_username();
$WP_PASS = get_wp_db_password();

// === WORDPRESS TABLE PREFIX ===
// It appears this generally doesn't change for different DBs in GoDaddy's hosting environment
$WP_PREFIX = get_table_prefix();

// === GLOBAL TABLE NAMES (built from prefix) ===
$WP_TERMS = $WP_PREFIX . 'terms';
$WP_TERM_TAXONOMY = $WP_PREFIX . 'term_taxonomy';
$WP_POSTS = $WP_PREFIX . 'posts';
$WP_POSTMETA = $WP_PREFIX . 'postmeta';
$USERS_TABLE = $WP_PREFIX . 'ap_users';
$TOKENS_TABLE = $WP_PREFIX . 'ap_tokens';

// === API CREDENTIALS ===
// Note: Affiliate API credentials are now configured in WordPress admin under Agentic Press → API Authentication