<?php
/**
 * User fields for Author Category Ownership plugin
 */

if (!defined('ABSPATH')) {
    exit;
}

class AP_User_Fields {

    /**
     * Constructor
     */
    public function __construct() {
        add_action('user_new_form', array($this, 'add_category_field'));
        add_action('show_user_profile', array($this, 'add_category_field'));
        add_action('edit_user_profile', array($this, 'add_category_field'));

        add_action('user_register', array($this, 'save_category_field'));
        add_action('personal_options_update', array($this, 'save_category_field'));
        add_action('edit_user_profile_update', array($this, 'save_category_field'));
    }

    /**
     * Add category field to user forms
     */
    public function add_category_field($user = null) {
        $assigned_categories = array();

        if (is_object($user)) {
            $assigned_categories = AP_DB::get_categories_by_author($user->ID);
        }

        ?>
        <h3><?php _e('Category Assignment', 'autopress'); ?></h3>
        <table class="form-table">
            <tr>
                <th><label><?php _e('Assigned Categories', 'autopress'); ?></label></th>
                <td>
                    <?php if (!empty($assigned_categories)): ?>
                        <ul style="margin: 0; padding-left: 1em;">
                            <?php foreach ($assigned_categories as $category): ?>
                                <li><strong><?php echo esc_html($category->name); ?></strong></li>
                            <?php endforeach; ?>
                        </ul>
                        <p class="description"><?php _e('You are assigned to these categories. Contact an administrator to change your category assignments.', 'autopress'); ?></p>
                    <?php else: ?>
                        <em><?php _e('No categories assigned', 'autopress'); ?></em>
                        <p class="description"><?php _e('Contact an administrator to assign you to categories.', 'autopress'); ?></p>
                    <?php endif; ?>
                </td>
            </tr>
        </table>
        <?php
    }

    /**
     * Render category options recursively
     */
    private function render_category_options($categories, $selected_id = null, $parent_id = null, $level = 0) {
        $indent = str_repeat('&nbsp;&nbsp;', $level);

        foreach ($categories as $category) {
            if ($category->parent_id == $parent_id) {
                $selected = ($selected_id == $category->id) ? 'selected="selected"' : '';
                echo '<option value="' . esc_attr($category->id) . '" ' . $selected . '>' . $indent . esc_html($category->name) . '</option>';

                // Render subcategories
                $this->render_category_options($categories, $selected_id, $category->id, $level + 1);
            }
        }
    }

    /**
     * Save category field (no longer used - assignments handled in admin)
     */
    public function save_category_field($user_id) {
        // Category assignments are now handled exclusively through the admin interface
        // This method is kept for compatibility but does nothing
    }
}